# Copyright (C) 2025 Arturs Ontuzans
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTIBILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.

import bpy, webbrowser
from bpy.types import AddonPreferences
from bpy.props import StringProperty

class UERiggingAddonPreferences(AddonPreferences):
    bl_idname = __package__

    root_bone_name: StringProperty(name='Root Bone Name', default='Root')
    body_bone_name: StringProperty(name='Body Bone Name', default='Body')
    RL_bone_name: StringProperty(name='Rear Left Bone Name', default='RL')
    RR_bone_name: StringProperty(name='Rear Right Bone Name', default='RR')
    FL_bone_name: StringProperty(name='Front Left Bone Name', default='FL')
    FR_bone_name: StringProperty(name='Front Right Bone Name', default='FR')
    N_bone_name: StringProperty(name='N-Bone Name', default='Wheel')
    caliper_bone_prefix: StringProperty(name='Caliper Bone Prefix', default='C')
    caliper_bone_suffix: StringProperty(name='Caliper Bone Suffix', default='')

    def draw(self, context):
        layout = self.layout
        grid = layout.grid_flow(columns = 3, align = True)
        grid.label(text = 'Root Bone Name')
        grid.label(text = 'Body Bone Name')
        grid.label(text = 'Rear Left Bone Name')
        grid.label(text = 'Rear Right Bone Name')
        grid.label(text = 'Front Left Bone Name')
        grid.label(text = 'Front Rigt Bone Name')
        grid.label(text = 'N-Wheel Bone Name')
        grid.label(text = 'Caliper Bone Prefix')
        grid.label(text = 'Caliper Bone Suffix')
        grid.prop(self, 'root_bone_name', text='')
        grid.prop(self, 'body_bone_name', text='')
        grid.prop(self, 'RL_bone_name', text='')
        grid.prop(self, 'RR_bone_name', text='')
        grid.prop(self, 'FL_bone_name', text='')
        grid.prop(self, 'FR_bone_name', text='')
        grid.prop(self, 'N_bone_name', text='')
        grid.prop(self, 'caliper_bone_prefix', text='')
        grid.prop(self, 'caliper_bone_suffix', text='')
        grid.operator('view3d.reset_preference', text = 'Reset To Default (Root)').property_name = 'root_bone_name'
        grid.operator('view3d.reset_preference', text = 'Reset To Default (Body)').property_name = 'body_bone_name'
        grid.operator('view3d.reset_preference', text = 'Reset To Default (RL)').property_name = 'RL_bone_name'
        grid.operator('view3d.reset_preference', text = 'Reset To Default (RR)').property_name = 'RR_bone_name'
        grid.operator('view3d.reset_preference', text = 'Reset To Default (FL)').property_name = 'FL_bone_name'
        grid.operator('view3d.reset_preference', text = 'Reset To Default (FR)').property_name = 'FR_bone_name'
        grid.operator('view3d.reset_preference', text = 'Reset To Default (Wheel)').property_name = 'N_bone_name'
        grid.operator('view3d.reset_preference', text = 'Reset To Default (C)').property_name = 'caliper_bone_prefix'
        grid.operator('view3d.reset_preference', text = 'Reset To Default').property_name = 'caliper_bone_suffix'
        row = layout.row()
        row.operator('view3d.open_continue_break_link')



class Reset_Preferences_Property_OT_Operator(bpy.types.Operator):
    bl_idname = 'view3d.reset_preference'
    bl_label = 'Reset'
    bl_description = 'Resets Preference Value to the Default Value'
    bl_options = {'REGISTER', 'UNDO'}

    property_name: bpy.props.StringProperty()

    def execute(self, context):
        preferences = context.preferences.addons[__package__].preferences

        default_value = preferences.bl_rna.properties[self.property_name].default
        setattr(preferences, self.property_name, default_value)

        return {'FINISHED'}

class Open_Link_OT_Operator(bpy.types.Operator):
    bl_idname = 'view3d.open_continue_break_link'
    bl_label = 'Check for Updates at ContinueBreak.com'
    bl_description = 'Opens the add-on homepage in your browser.'

    def execute(self, context):
        webbrowser.open('https://continuebreak.com/creations/ue-vehicle-rigging-addon-blender/')

        return {'FINISHED'}
