# Copyright (C) 2025 Arturs Ontuzans
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTIBILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.

import bpy
from . helper_methods import show_object_vertext_groups

class Get_Mesh_Vertex_Group_Weight_Sums_OT_Operator(bpy.types.Operator):
    bl_idname = "view3d.get_vertex_group_sums"
    bl_label = "Get Active Object Weights"
    bl_description = "Gets selected object Vertex Group overall sums"
    bl_options = {'REGISTER', 'UNDO'}

    @classmethod
    def poll(cls, context):
        selected_object = context.active_object
        return selected_object is not None and selected_object.type == 'MESH' and selected_object.select_get()

    def execute(self, context):
        scene = context.scene

        C = bpy.context 
        D = bpy.data
        O = bpy.ops

        obj = C.view_layer.objects.active
        scene.troubleshoot_object = obj
        show_object_vertext_groups(obj)

        return {'FINISHED'}
    
class Update_Mesh_Weights_From_List_OT_Operator(bpy.types.Operator):
    bl_idname = "view3d.update_mesh_weights_from_list"
    bl_label = "Update Object's Vertex Weights"
    bl_description = "Updates Troubleshooting Object Vertex Weights from The List"
    bl_options = {'REGISTER', 'UNDO'}

    @classmethod
    def poll(cls, context):
        troubleshooting_object = context.scene.troubleshoot_object
        return troubleshooting_object is not None and troubleshooting_object.type == 'MESH'

    def execute(self, context):
        scene = context.scene

        C = bpy.context 
        D = bpy.data
        O = bpy.ops

        mesh = scene.troubleshoot_object

        #Make a new list for all vertice indexes
        index_list = [v.index for v in mesh.data.vertices]
        #Populate index list with vertice indexes
        mesh.data.vertices.foreach_get('index', index_list)   
        #Set mesh vertex group
        for weight in scene.object_vertex_group_weights:
            mesh.vertex_groups[weight.name].add(index_list, weight.value, 'REPLACE')

        return {'FINISHED'}
    
class Set_3D_Cursor_To_Location_OT_Operator(bpy.types.Operator):
    bl_idname = "view3d.set_3d_cursor_to_location"
    bl_label = "Set 3D cursor to this"
    bl_description = "Set's 3D cursor to location"
    bl_options = {'REGISTER', 'UNDO'}

    new_location: bpy.props.FloatVectorProperty(subtype = 'XYZ', unit = 'LENGTH')

    def execute(self, context):
        scene = context.scene

        scene.cursor.location = self.new_location
        
        return {'FINISHED'}